/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.Arrays;
import net.maizegenetics.util.SuperByteMatrix;

public class SuperByteMatrixSingleValue
implements SuperByteMatrix {
    private byte myData;
    private final int myNumRows;
    private final int myNumColumns;

    SuperByteMatrixSingleValue(int rows, int columns, byte value) {
        this.myNumRows = rows;
        this.myNumColumns = columns;
        this.myData = value;
    }

    @Override
    public byte get(int row, int column) {
        return this.myData;
    }

    @Override
    public byte[] getAllColumns(int row) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingleValue: getAllColumns: row: " + row);
        }
        byte[] result = new byte[this.myNumColumns];
        Arrays.fill(result, this.myData);
        return result;
    }

    @Override
    public byte[] getColumnRange(int row, int start, int end) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingleValue: getColumnRange: row: " + row);
        }
        if (start < 0 || start >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingleValue: getColumnRange: start: " + start);
        }
        if (end < 0 || end >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingleValue: getColumnRange: end: " + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("SuperByteMatrixSingleValue: getColumnRange: end: " + end + " less than start: " + start);
        }
        int numElements = end - start;
        byte[] result = new byte[numElements];
        Arrays.fill(result, this.myData);
        return result;
    }

    @Override
    public byte[] getAllRows(int column) {
        if (column < 0 || column >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingleValue: getAllRows: column: " + column);
        }
        byte[] result = new byte[this.myNumRows];
        for (int i = 0; i < this.myNumRows; ++i) {
            result[i] = this.myData;
        }
        return result;
    }

    @Override
    public int getNumRows() {
        return this.myNumRows;
    }

    @Override
    public int getNumColumns() {
        return this.myNumColumns;
    }

    @Override
    public boolean isColumnInnerLoop() {
        return true;
    }

    @Override
    public void setHetsTo(byte value) {
        if ((this.myData >>> 4 & 0xF) != (this.myData & 0xF)) {
            this.myData = value;
        }
    }

    @Override
    public void set(int row, int column, byte value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void arraycopy(int row, byte[] src, int startColumn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAll(byte value) {
        this.myData = value;
    }

    @Override
    public void reorderRows(int[] newIndices) {
    }

    @Override
    public void reorderColumns(int[] newIndices) {
    }
}

