/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.maizegenetics.util.DoubleFormat;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.SimpleTableReport;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TableReportUtils {
    private static final Logger myLogger = Logger.getLogger(TableReportUtils.class);

    public static void saveDelimitedTableReport(TableReport theTableSource, String delimit, File saveFile) {
        if (saveFile == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = Utils.getBufferedWriter(saveFile);
            Object[] colNames = theTableSource.getTableColumnNames();
            for (int j = 0; j < colNames.length; ++j) {
                if (j != 0) {
                    bw.write(delimit);
                }
                bw.write(colNames[j].toString());
            }
            bw.write("\n");
            long n = theTableSource.getRowCount();
            for (long r = 0L; r < n; ++r) {
                Object[] theRow = theTableSource.getRow(r);
                for (int i = 0; i < theRow.length; ++i) {
                    if (i != 0) {
                        bw.write(delimit);
                    }
                    if (theRow[i] == null) continue;
                    if (theRow[i] instanceof Double) {
                        bw.write(DoubleFormat.format((Double)theRow[i]));
                        continue;
                    }
                    bw.write(theRow[i].toString());
                }
                bw.write("\n");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TableReportUtils: writeReport: problem writing file: " + saveFile.getName() + "\n" + e.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static TableReport readDelimitedTableReport(String saveFile, String delimit) {
        myLogger.info((Object)("readDelimitedTableReport: Reading: " + saveFile));
        int numLines = Utils.getNumberLines(saveFile) - 1;
        myLogger.info((Object)("readDelimitedTableReport: Num Lines (Not including header): " + numLines));
        Pattern delimitPattern = Pattern.compile(delimit);
        BufferedReader br = null;
        try {
            br = Utils.getBufferedReader(saveFile);
            Object[] columnHeaders = delimitPattern.split(br.readLine().trim());
            int numThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            Object[][] data = new String[numLines][];
            int maxNumLinesPerThread = 100000;
            for (int i = 0; i < numLines; i += maxNumLinesPerThread) {
                int numLinesForThread = Math.min(maxNumLinesPerThread, numLines - i);
                String[] lines = new String[numLinesForThread];
                for (int j = 0; j < numLinesForThread; ++j) {
                    lines[j] = br.readLine().trim();
                }
                pool.execute(new SplitTableReportString((String[][])data, i, lines, delimitPattern));
            }
            pool.shutdown();
            if (!pool.awaitTermination(6000L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("TableReportUtils: readDelimitedTableReport: processing threads timed out.");
            }
            SimpleTableReport simpleTableReport = new SimpleTableReport(saveFile, columnHeaders, data);
            return simpleTableReport;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Problem creating TableReport: " + saveFile + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ex) {
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static Table<Integer, String, Object> convertTableReportToGuavaTable(TableReport tr) {
        int i;
        ImmutableTable.Builder result = new ImmutableTable.Builder();
        String[] colNames = new String[tr.getColumnCount()];
        for (i = 0; i < colNames.length; ++i) {
            colNames[i] = tr.getTableColumnNames()[i].toString();
        }
        i = 0;
        while ((long)i < tr.getRowCount()) {
            for (int j = 0; j < tr.getColumnCount(); ++j) {
                result.put((Object)i, (Object)colNames[j], tr.getValueAt(i, j));
            }
            ++i;
        }
        return result.build();
    }

    private static class SplitTableReportString
    implements Runnable {
        private final String[][] myData;
        private int myLineNum;
        private final String[] myLines;
        private final Pattern myPattern;

        public SplitTableReportString(String[][] data, int lineNum, String[] lines, Pattern pattern) {
            this.myData = data;
            this.myLineNum = lineNum;
            this.myLines = lines;
            this.myPattern = pattern;
        }

        @Override
        public void run() {
            int n = this.myLines.length;
            for (int i = 0; i < n; ++i) {
                this.myData[this.myLineNum++] = this.myPattern.split(this.myLines[i]);
            }
        }
    }
}

