/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.analysis.gbs.Barcode;

class TrieNode {
    public TrieNode parent;
    public TrieNode[] children = new TrieNode[26];
    public boolean isLeaf = true;
    public boolean isWord = false;
    private char character;
    private Barcode theBarcode;

    public TrieNode() {
    }

    public TrieNode(char character) {
        this();
        this.character = character;
    }

    protected void addWord(String word) {
        this.isLeaf = false;
        int charPos = word.charAt(0) - 97;
        if (this.children[charPos] == null) {
            this.children[charPos] = new TrieNode(word.charAt(0));
            this.children[charPos].parent = this;
        }
        if (word.length() > 1) {
            this.children[charPos].addWord(word.substring(1));
        } else {
            this.children[charPos].isWord = true;
        }
    }

    protected TrieNode getNode(char c) {
        return this.children[c - 97];
    }

    public boolean containsKey(char c) {
        ArrayList<Character> followers = new ArrayList<Character>();
        for (TrieNode x : this.children) {
            if (x == null) continue;
            char y = x.character;
            followers.add(Character.valueOf(y));
        }
        return followers.contains(Character.valueOf(c));
    }

    protected List getWords() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isWord) {
            list.add(this.toString());
        }
        if (!this.isLeaf) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                list.addAll(this.children[i].getWords());
            }
        }
        return list;
    }

    public String toString() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.toString() + new String(new char[]{this.character});
    }
}

