/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.lang.ZTrackable;
import ext.swing.ZButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public abstract class ZAbstractProgressPanel
extends JPanel
implements ZTrackable {
    protected JFrame frame = null;
    private Thread thread = null;
    private boolean interrupted = false;
    private boolean aborted = false;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel P_progress = new JPanel();
    private JLabel L_status = new JLabel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JProgressBar progressBar = new JProgressBar();
    private ZButton B_abort = new ZButton();
    private JPanel P_status = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();

    public ZAbstractProgressPanel(JFrame f) {
        try {
            this.frame = f;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void compute(Object var1) throws Exception;

    protected abstract void finished();

    public void setProgress(final float progress) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue((int)(progress * (float)100));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZAbstractProgressPanel.this.progressBar.setValue((int)(progress * (float)100));
                }
            });
        }
    }

    public void setProgressText(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.L_status.setText(text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZAbstractProgressPanel.this.L_status.setText(text);
                }
            });
        }
    }

    private void setAbortEnabled(final boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.B_abort.setEnabled(b);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZAbstractProgressPanel.this.B_abort.setEnabled(b);
                }
            });
        }
    }

    private void safeFinished() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.finished();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZAbstractProgressPanel.this.finished();
                }
            });
        }
    }

    public boolean getInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean b) {
        this.interrupted = b;
    }

    public void sleep(int mini) {
        try {
            Thread.sleep(mini);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setAborted(boolean b) {
        this.aborted = b;
    }

    public boolean getAborted() {
        return this.aborted;
    }

    public void doJob(final Object obj) {
        this.thread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        ZAbstractProgressPanel.this.setAborted(false);
                        ZAbstractProgressPanel.this.setInterrupted(false);
                        ZAbstractProgressPanel.this.compute(obj);
                    }
                    catch (Exception ex) {
                        ZAbstractProgressPanel.this.setAborted(true);
                        if (SwingUtilities.isEventDispatchThread()) {
                            JOptionPane.showMessageDialog(ZAbstractProgressPanel.this.frame, ex.getMessage());
                        } else {
                            SwingUtilities.invokeLater(new Runnable(this, ex){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$ex = val$ex;
                                }

                                public void run() {
                                    JOptionPane.showMessageDialog(5.access$3(this.this$1).frame, this.val$ex.getMessage());
                                }
                            });
                        }
                        Object var3_2 = null;
                        ZAbstractProgressPanel.this.setProgress(0.0f);
                        ZAbstractProgressPanel.this.setProgressText("Ready");
                        ZAbstractProgressPanel.this.setAbortEnabled(false);
                        ZAbstractProgressPanel.this.safeFinished();
                        return;
                    }
                    Object var3_1 = null;
                    ZAbstractProgressPanel.this.setProgress(0.0f);
                    ZAbstractProgressPanel.this.setProgressText("Ready");
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    ZAbstractProgressPanel.this.setProgress(0.0f);
                    ZAbstractProgressPanel.this.setProgressText("Ready");
                    ZAbstractProgressPanel.this.setAbortEnabled(false);
                    ZAbstractProgressPanel.this.safeFinished();
                    throw throwable;
                }
                ZAbstractProgressPanel.this.setAbortEnabled(false);
                ZAbstractProgressPanel.this.safeFinished();
            }

            static /* synthetic */ ZAbstractProgressPanel access$3(5 x$0) {
                return x$0.ZAbstractProgressPanel.this;
            }
        });
        this.thread.start();
        this.setAbortEnabled(true);
    }

    private void jbInit() throws Exception {
        this.setMinimumSize(new Dimension(600, 24));
        this.setPreferredSize(new Dimension(600, 24));
        this.setLayout(this.borderLayout1);
        this.P_progress.setLayout(this.flowLayout1);
        this.L_status.setText("Ready");
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setVgap(1);
        this.progressBar.setMinimumSize(new Dimension(10, 22));
        this.progressBar.setPreferredSize(new Dimension(150, 22));
        this.progressBar.setStringPainted(true);
        this.B_abort.set("abort", null, null);
        this.B_abort.setEnabled(false);
        this.B_abort.setMaximumSize(new Dimension(80, 22));
        this.B_abort.setMinimumSize(new Dimension(80, 22));
        this.B_abort.setPreferredSize(new Dimension(80, 22));
        this.B_abort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZAbstractProgressPanel.this.B_abort_actionPerformed(e);
            }
        });
        this.P_status.setLayout(this.borderLayout2);
        this.P_status.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.P_progress, "East");
        this.P_progress.add((Component)this.progressBar, null);
        this.P_progress.add((Component)this.B_abort, null);
        this.add((Component)this.P_status, "Center");
        this.P_status.add((Component)this.L_status, "Center");
    }

    private void B_abort_actionPerformed(ActionEvent e) {
        this.setInterrupted(true);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        final JTextArea area = new JTextArea();
        f.getContentPane().add((Component)area, "Center");
        f.getContentPane().add((Component)new ZAbstractProgressPanel(f){

            protected void compute(Object obj) throws Exception {
                for (long l = 0L; l < (long)100000; ++l) {
                    if (l % (long)1000 != (long)0) continue;
                    this.setProgress((float)l / (float)100000);
                    this.setProgressText("Progress is ".concat(String.valueOf(String.valueOf(l / (long)1000))));
                    if (this.getInterrupted()) {
                        throw new Exception("Interrupted by user.");
                    }
                    Thread.sleep(100L);
                }
            }

            protected void finished() {
                if (this.getAborted()) {
                    area.setText("Aborted");
                } else {
                    area.setText("Not aborted");
                }
            }
        }, "South");
        JButton button = new JButton("button");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ZAbstractProgressPanel)f.getContentPane().getComponent(1)).doJob("xyz");
            }
        });
        f.getContentPane().add((Component)button, "North");
        ((Component)f).setSize(600, 480);
        f.show();
    }
}

