/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class ZTableModel
extends AbstractTableModel {
    private boolean[][] boolMatrix = new boolean[0][0];
    private Object[][] data = new Object[0][0];
    private String[] header = new String[0];

    public ZTableModel() {
    }

    public ZTableModel(Object[][] data, String[] header) {
        this.data = data;
        this.header = header;
        this.boolMatrix = new boolean[this.getRowCount()][this.getColumnCount()];
        this.setTableEditable(false);
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        if (this.data.length == 0) {
            return 0;
        }
        return this.data[0].length;
    }

    public Object getValueAt(int row, int column) {
        return this.data[row][column];
    }

    public boolean isCellEditable(int row, int column) {
        return this.boolMatrix[row][column];
    }

    public String getColumnName(int column) {
        return this.header[column].toString();
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = value;
    }

    public void setColumnEditable(int column, boolean b) {
        for (int i = 0; i < this.boolMatrix.length; ++i) {
            this.boolMatrix[i][column] = b;
        }
    }

    public void setRowEditable(int row, boolean b) {
        if (this.boolMatrix.length == 0) {
            return;
        }
        for (int i = 0; i < this.boolMatrix[0].length; ++i) {
            this.boolMatrix[row][i] = b;
        }
    }

    public void setCellEditable(int row, int column, boolean b) {
        this.boolMatrix[row][column] = b;
    }

    public void setTableEditable(boolean b) {
        for (int i = 0; i < this.boolMatrix.length; ++i) {
            Arrays.fill(this.boolMatrix[i], b);
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    public Object[][] getData() {
        return this.data;
    }
}

