/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
SVGConstants {
    protected transient boolean readonly;
    protected String prefix;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getId() {
        return this.getID();
    }

    public void setId(String string) {
        this.setAttributeNS(null, "id", string);
    }

    public String getXMLbase() {
        return XMLBaseSupport.getXMLBase((Element)((Object)this));
    }

    public void setXMLbase(String string) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", string);
    }

    public SVGSVGElement getOwnerSVGElement() {
        Element element = HiddenChildElementSupport.getParentElement((Element)((Object)this));
        while (element != null) {
            if (element instanceof SVGSVGElement) {
                return (SVGSVGElement)element;
            }
            element = HiddenChildElementSupport.getParentElement((Element)element);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof SVGFitToViewBox) {
                return (SVGElement)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        String string = this.getLocalName();
        StringBuffer stringBuffer = new StringBuffer(this.prefix.length() + string.length() + 1);
        stringBuffer.append(this.prefix).append(':').append(string);
        return stringBuffer.toString();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (string != null && !string.equals("") && !DOMUtilities.isValidName((String)string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        this.prefix = string;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)node);
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)node);
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)node);
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)node);
        sVGOMElement.prefix = this.prefix;
        return node;
    }
}

