/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TileRable8Bit;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class PatternPaintContext
implements PaintContext {
    private ColorModel rasterCM;
    private WritableRaster raster;
    private RenderedImage tiled;
    private static Rectangle EVERYTHING = new Rectangle(-536870912, -536870912, 0x3FFFFFFF, 0x3FFFFFFF);

    public PatternPaintContext(ColorModel colorModel, AffineTransform affineTransform, RenderingHints renderingHints, Filter filter, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (affineTransform == null) {
            throw new IllegalArgumentException();
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        TileRable8Bit tileRable8Bit = new TileRable8Bit(filter, (Rectangle2D)EVERYTHING, rectangle2D, bl);
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            tileRable8Bit.setColorSpaceLinear(false);
        } else if (colorSpace == ColorSpace.getInstance(1004)) {
            tileRable8Bit.setColorSpaceLinear(true);
        }
        RenderContext renderContext = new RenderContext(affineTransform, EVERYTHING, renderingHints);
        this.tiled = tileRable8Bit.createRendering(renderContext);
        if (this.tiled != null) {
            Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
            if (((RectangularShape)rectangle).getWidth() > 128.0 || ((RectangularShape)rectangle).getHeight() > 128.0) {
                this.tiled = new TileCacheRed(GraphicsUtil.wrap((RenderedImage)this.tiled), 256, 64);
            }
        } else {
            this.rasterCM = ColorModel.getRGBdefault();
            WritableRaster writableRaster = this.rasterCM.createCompatibleWritableRaster(32, 32);
            this.tiled = GraphicsUtil.wrap((RenderedImage)new BufferedImage(this.rasterCM, writableRaster, false, null));
            return;
        }
        this.rasterCM = this.tiled.getColorModel();
        if (this.rasterCM.hasAlpha()) {
            this.rasterCM = colorModel.hasAlpha() ? GraphicsUtil.coerceColorModel((ColorModel)this.rasterCM, (boolean)colorModel.isAlphaPremultiplied()) : GraphicsUtil.coerceColorModel((ColorModel)this.rasterCM, (boolean)false);
        }
    }

    public void dispose() {
        this.raster = null;
    }

    public ColorModel getColorModel() {
        return this.rasterCM;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.raster == null || this.raster.getWidth() < n3 || this.raster.getHeight() < n4) {
            this.raster = this.rasterCM.createCompatibleWritableRaster(n3, n4);
        }
        WritableRaster writableRaster = this.raster.createWritableChild(0, 0, n3, n4, n, n2, null);
        this.tiled.copyData(writableRaster);
        GraphicsUtil.coerceData((WritableRaster)writableRaster, (ColorModel)this.tiled.getColorModel(), (boolean)this.rasterCM.isAlphaPremultiplied());
        if (this.raster.getWidth() == n3 && this.raster.getHeight() == n4) {
            return this.raster;
        }
        return writableRaster.createTranslatedChild(0, 0);
    }
}

