"""
The module is about the irreducible trinomials with the form of $x^m+x^t+2$. 
Given the value of $m$ that is the degree of the irreducible trinomial, $table[m]$ is the value of $t$. 

Usage: 
    $table[97]==12$ means the irreducible trinomial with the degree of 97 is $x^97 + x^12 + 2$.
    $table[10]$ is missing, which means there is no such irreducible trinomial with the degree of 10.
"""

table = {
    2:1, 3:2, 4:1, 5:4, 6:1,
    7:2, 8:2, 9:4, 11:2, 12:2,
    13:4, 14:1, 15:2, 16:4, 17:16,
    18:7, 19:2, 20:5, 21:16, 22:5,
    23:8, 24:4, 25:6, 26:7, 27:20,
    28:2, 29:4, 30:1, 31:20, 32:5,
    33:28, 35:2, 36:14, 37:6, 39:26,
    40:1, 41:40, 42:7, 43:26, 44:3,
    45:28, 46:5, 47:32, 48:8, 51:50,
    52:7, 53:22, 54:1, 55:26, 56:3,
    59:20, 60:2, 61:30, 63:26, 64:3,
    67:2, 69:52, 71:20, 72:28, 73:30,
    76:9, 77:16, 78:13, 79:26, 80:2,
    81:40, 83:32, 84:14, 85:16, 86:13,
    87:26, 88:6, 89:64, 90:19, 91:74,
    92:10, 93:70, 95:48, 96:16, 97:12,
    99:74, 100:25, 101:70, 102:25, 103:50,
    104:5, 107:32, 108:2, 109:88, 111:2,
    112:6, 113:70, 114:7, 115:32, 116:15,
    117:52, 119:2, 120:4, 121:40, 124:25,
    125:52, 126:49, 127:8, 128:6, 131:48,
    133:88, 134:61, 135:44, 136:57, 137:136,
    139:80, 140:59, 141:64, 142:65, 143:108,
    144:56, 145:24, 147:8, 148:3, 150:73,
    151:2, 152:18, 153:94, 155:12, 156:26,
    157:22, 158:61, 159:32, 160:4, 162:19,
    163:80, 164:15, 165:22, 167:92, 168:28,
    169:24, 170:43, 171:20, 172:19, 173:166,
    174:73, 176:12, 177:52, 178:11, 179:104,
    180:38, 181:40, 182:25, 183:2, 184:20,
    185:64, 186:47, 187:8, 188:11, 191:116,
    192:32, 193:12, 194:55, 195:26, 196:79,
    198:29, 199:164, 200:3, 201:88, 203:8,
    204:50, 205:78, 206:61, 208:10, 209:40,
    210:7, 211:122, 214:65, 215:36, 216:4,
    217:132, 219:26, 220:15, 222:89, 224:12,
    225:16, 227:68, 228:14, 229:72, 230:73,
    232:30, 234:91, 235:26, 236:9, 237:70,
    238:5, 239:24, 240:8, 241:88, 242:115,
    243:122, 244:31, 245:148, 246:13, 247:122,
    248:50, 249:76, 251:26, 252:98, 253:12,
    254:73, 255:26,
}
