#!/usr/bin/python
#Last-modified: 02 Oct 2014 20:59:47

#         Module/Scripts Description
#
# Copyright (c) 2008 1.1.0 &lt;Yunfei Wang&gt;
#
# This code is free software; you can redistribute it and/or modify it
# under the terms of the BSD License (see the file COPYING included with
# the distribution).
#
# @status:  experimental
# @version: 1.1.0
# @author:  Yunfei Wang
# @contact: yfwang0405@gmail.com

# ------------------------------------
# Python packages
# ------------------------------------

import sys
import string
from testbedlib import Bed3,BedGraph

# ------------------------------------
# constants
# ------------------------------------

# ------------------------------------
# Misc functions
# ------------------------------------

# ------------------------------------
# Classes
# ------------------------------------



# ------------------------------------
# Main
# ------------------------------------

if __name__=="__main__":
    if len(sys.argv)==1:
        sys.exit("Example:"+sys.argv[0]+" file1 file2... ")
    infile = sys.argv[1]
    if infile.endswith('bed'):
        parser = Bed3
    elif infile.endswith('bedgraph'):
        parser = BedGraph
    else:
        pass
    
    for line in open(infile):
        bed = parser(line)
        print bed
        print len(bed)
        print bed.extend(50,50)
        print

