import unittest
from flask import Flask, jsonify
from browser import Browser


class TestBrowser(unittest.TestCase):
	sample_text = "This is some sample text, and it is good!"
	def setUp(self):
		self.app = Flask('testapp')
		@self.app.route('/')
		def index():
			return "Hello World"

		@self.app.route('/error')
		def error():
			return "Error Here", 400

		@self.app.route('/not_html')
		def not_html():
			return jsonify({'not': 'html'})

		@self.app.route('/sample_text')
		def sample_text():
			return self.sample_text

	def test_instantiate(self):
		""" Browser class can be instantiated without exploding.
		"""
		browser = Browser(self.app)

	def test_open(self):
		""" Browser class can open a url in an app.
		"""
		browser = Browser(self.app)
		browser.open('/')

	def test_open_asserts_status_is_ok(self):
		""" Browser asserts that the response status code is ok when asked to.
		"""
		browser = Browser(self.app)
		self.assertRaises(AssertionError, browser.open, '/error')

	def test_open_asserts_response_is_html(self):
		""" Browser asserts that the response is html when asked to.
		"""
		browser = Browser(self.app)
		self.assertRaises(AssertionError, browser.open, '/not_html')

	def test_get_text(self):
		""" Browser can correctly return the response.
		"""
		browser = Browser(self.app)
		browser.open('/sample_text')
		self.assertEquals(self.sample_text, browser.get_text())

	def test_get_text_asserts_has_opened_url(self):
		""" Browser checks it has opened a url before attempting to return the response text.
		"""
		browser = Browser(self.app)
		self.assertRaises(AssertionError, browser.get_text)

	def test_is_text_present_asserts_has_opened_url(self):
		""" Browser checks it has opened a url before attempting to check for text in the response.
		"""
		browser = Browser(self.app)
		self.assertRaises(AssertionError, browser.is_text_present, "Some Text")

	def test_is_text_present(self):
		""" Browser correctly tests whether some given text is present in the response.
		"""
		browser = Browser(self.app)
		browser.open('/sample_text')
		self.assertTrue(browser.is_text_present(self.sample_text[5: 10]))

if __name__ == '__main__':
	unittest.main()