import mechanize
from mechanize import LinkNotFoundError
from HTMLParser import HTMLParser

class Browser(object):
	""" A mechanize browser driving a flask app.
	"""
	def __init__(self, app):
		""" Make a new Browser object browsing the specified app.
		"""
		# The internal mechanize browser.
		self._browser = mechanize.Browser()
		# The app to be browsed.
		self.app = app.test_client()
		# An instance of HTMLParser to inspect the returned web pages.
		self.parser = HTMLParser()
		# A flag to keep track of whether the browser has opened a url yet.
		self.has_opened_url = False

	def open(self, url, assert_response_is_html=True, assert_status_is_ok=True):
		""" Open a (relative) url.
		"""
		# Make a GET request to the flask app.
		flask_response = self.app.get(url)
		if assert_status_is_ok:
			#TODO: Add all 'OK' satus codes.
			assert flask_response.status_code in [200],\
				"The app returned an error response code: %d,\nresponse was:%s" % (flask_response.status_code, flask_response.data)
		# Make a mechanize response out of the flask response.
		mechanize_response = mechanize.make_response(
			flask_response.data,
			flask_response.headers,
			url,
			flask_response.status_code,
			flask_response.status.split(' ')[1])
		# Point the browser to the new response.
		self._browser.visit_response(mechanize_response)
		# Check that the returned page is html.
		if assert_response_is_html:
			#TODO: Add the mimetype to the assert error message.
			assert self._browser.viewing_html(),\
			"The app did not return html."
		self.has_opened_url = True

	def is_text_present(self, expected_text):
		""" Check if expected_text appears in the response.
		"""
		assert self.has_opened_url, "Browser has not opened a url yet."
		return expected_text in self.get_text()

	def is_link_present(self, text, url):
		assert self.has_opened_url, "Browser has not opened a url yet."
		try:
			self._browser.find_link(text=text)
			return True
		except LinkNotFoundError:
			return False

	def get_text(self):
		assert self.has_opened_url, "Browser has not opened a url yet."
		return self.parser.unescape(self._browser.response().read())
