class TestCaseMixin(object):
	def assertTextIsPresent(self, text, browser=None):
		if not browser:
			browser = self.browser
		if not browser.is_text_present(text):
			self.fail(
				'Text "%s" not present in response.\nResponse was: "%s"' %
				(text, browser.get_text()))

	def assertLinkIsPresent(self, text, url, browser=None):
		if not browser:
			browser = self.browser
		if not browser.is_link_present(text, url):
			self.fail(
				"Link with text=%s and url=%s not present in the page.\nResponse was:\n%s" %
				(text, url, browser.get_text()))
