
from testharness import import_from_parent, test_run
import_from_parent()

from textdata import *

def single_trial(name, t, **kwargs):
    print "---", name, "---"
    reslines = lines(t, **kwargs)
    for line in reslines:
        print line
    print "--- end", name, "---"

    print
    
def test_lines():
    single_trial('test1', """
    This is a test of lines
    these should all
    be nice and dedented
        except this one, which has a little non-common space
    ok?
    because ends with more than one blank line, those will be captured
    
    
          """, noblanks=False)
    
    single_trial('test2', """
                
                
    This is a test of lines
    
    here there should be no blanks
     but some that start wiht a little extra space ok?
      which isn't common
      

    
          """)

def test_textlines():
    lresult = lines("""
                
                
    This is a test of lines
    
    here there should be no blanks
     but some that start wiht a little extra space ok?
      which isn't common
      

    
          """)
    
    tresult = textlines("""
                
                
    This is a test of lines
    
    here there should be no blanks
     but some that start wiht a little extra space ok?
      which isn't common
      

    
          """)
    
    assert lresult == tresult.splitlines()
    
        
if __name__ == '__main__':
    test_run()
    
