#! /usr/bin/env python

from setuptools import setup
from decimal import Decimal
import re

def verno(s):
    """
    Update the version number passed in by extending it to the 
    thousands place and adding 1/1000, then returning that result
    and as a side-effect updating setup.py

    Dangerous, self-modifying, and also, helps keep version numbers
    ascending without human intervention.
    """
    d = Decimal(s)
    increment = Decimal('0.001')
    d = d.quantize(increment) + increment
    dstr = str(d)
    setup = open('setup.py', 'r').read()
    setup = re.sub('verno\(\w*[\'"]([\d\.]+)[\'"]', 'verno("' + dstr + '"', setup)
    open('setup.py', 'w').write(setup)
    return dstr

setup(
    name='textdata',
    version=verno("0.402"),
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description='Get clean line or text data from multi-line strings',
    long_description=open('README.rst', 'r').read(),
    url='https://bitbucket.org/jeunice/textdata',
    py_modules=['textdata'],
    install_requires=[],
    tests_require = ['tox', 'pytest'],
    zip_safe = True,
    keywords='text data lines',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: BSD License',
        'Intended Audience :: Developers',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.5',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
    ]
)