#!/usr/bin/env python

from setuptools import setup

setup(
    name='textdata',
    version='1.0.1',
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description='Get clean line or text data from multi-line strings',
    long_description=open('README.rst').read(),
    url='https://bitbucket.org/jeunice/textdata',
    py_modules=['textdata'],
    install_requires=[],
    tests_require = ['tox', 'pytest'],
    zip_safe = False,  # it really is, but this will prevent weirdness
    keywords='text data lines dedent',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: BSD License',
        'Intended Audience :: Developers',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
