#!/usr/bin/env python
"""
Command line UI loop

- "initialize with an arbitrary text file"
- "repeated searches"
- stop on "empty search term"
- "takes an integer to specify the number of surrounding context words"
- display one result per line
"""

import os

from . import search


def get_filename():
    try_again = True
    while try_again:
        fn = raw_input("Enter file to search: ").strip()
        if fn == '':  # exit, don't do anything
            return ''
        fn = os.path.expanduser(fn)
        fn = os.path.realpath(fn)
        if not os.path.exists(fn):
            print "File %s does not exist, please try again" % fn
            continue
        if not os.path.isfile(fn):
            print "%s is not a regular file, please try again" % fn
            continue
        try_again = False
    return fn


def get_search_term():
    return raw_input("Enter search term: ")


def get_n_context_words():
    try_again = True
    while try_again:
        i = raw_input("Enter number of context words: ")
        try:
            i = int(i.strip())
            if i > -1:
                try_again = False
            else:
                print "Number of context words[%i] must be 0 or greater" % i
        except ValueError:
            print "%s is not a valid int, please try again" % i
    return i


def show_results(rs):
    print  # blank line
    for r in rs:
        print ' '.join(r)
    print  # blank line


def process_file(fn):
    # check filename
    if not os.path.exists(fn):
        raise IOError("File %s does not exist" % fn)
    if not os.path.isfile(fn):
        raise IOError("%s is not a regular file" % fn)

    # load filename
    with open(fn, 'r') as f:
        ts = search.TextSearch(f.read())

    # enter loop
    while True:
        st = get_search_term()
        if st == '':
            return
        nc = get_n_context_words()
        show_results(ts.search(st, nc))
    return


def ui():
    fn = get_filename()
    if fn != '':
        process_file(fn)
    print "<exiting>"
