#!/usr/bin/env python

import string  # for string.punctuation

_t = string.maketrans("", "")


def remove_punctuation(s):
    return s.translate(_t, string.punctuation)


def remove_leading_punctuation(s):
    return s[s.index(remove_punctuation(s)):]


def remove_trailing_punctuation(s):
    return remove_leading_punctuation(s[::-1])[::-1]


def test():
    assert remove_punctuation('blah.') == 'blah'
    assert remove_punctuation('blah:') == 'blah'
    assert remove_leading_punctuation('blah.') == 'blah.'
    assert remove_trailing_punctuation('blah.') == 'blah'
    assert remove_leading_punctuation('.blah') == 'blah'
    assert remove_trailing_punctuation('.blah') == '.blah'
    assert remove_trailing_punctuation('blah:') == 'blah'
