#!/usr/bin/env python

from . import index
from . import ops
from . import search


test_string = """Provide a utility to search text files. The tool should have at least two functions: one to initialize the tool with an arbitrary text file, and another to provide search results of the text file for a given search term. The tool should allow for repeated searches to be made, stopping when the user enters an empty search term. In addition to the search term, the search function also takes an integer to specify the number of surrounding context words, if available, to display in the results. If this value is 1, then 1 preceding word, and 1 following word should be displayed. One result (including context words) should be displayed for each occurrence of the search term in the text file. Do not include punctuation before the first context word or after the last context word. Include punctuation placed after the first context word and before the last context word. NB: Good solutions will be written with careful consideration to minimize the amount of time it takes to perform each search. Although the time to initialize the tool may increase as the size of the text file does, please minimize the time required to perform searches subsequent to the initialization. It's okay to use data structures from your language's standard library."""


def run_dependency_tests():
    index.test()
    ops.test()
    search.test()


def test_all():
    run_dependency_tests()
    ts = search.TextSearch(test_string)

    rs = ts.search('context', 2)
    assert len(rs) == 6
    assert ' '.join(rs[0]) == 'of surrounding context words, if'
    assert ' '.join(rs[1]) == 'result (including context words) should'
    assert ' '.join(rs[2]) == 'the first context word or'
    assert ' '.join(rs[3]) == 'the last context word. Include'
    assert ' '.join(rs[4]) == 'the first context word and'
    assert ' '.join(rs[5]) == 'the last context word. NB'

    rs = ts.search('available', 1)
    assert len(rs) == 1
    assert ' '.join(rs[0]) == 'if available, to'

    rs = ts.search('last', 2)
    assert len(rs) == 2
    assert ' '.join(rs[0]) == 'after the last context word'
    assert ' '.join(rs[1]) == 'before the last context word'
