<%inherit file="local:templates.master"/>

<%def name="title()">
Learning TurboGears 2.3: Quick guide to the Quickstart pages.
</%def>

    <div class="row">
      <div class="col-md-12">
        <div class="page-header">
          <h2>Architectural basics of a quickstart TG2 site.</h2>
        </div>

        <p>The TG2 quickstart command produces this basic TG site. Here's how it works.</p>
      </div>
    </div>

    <div class="row">
      <div class="col-md-4">
        <div class="well">
          <ul class="nav nav-list">
            <li class="nav-header">About Architecture</li>
            <li><a href="#data-model">Data Model</a></li>
            <li><a href="#url-structure">URL Structure</a></li>
            <li><a href="#template-reuse">Templates</a></li>
            % if tg.auth_stack_enabled:
            <li class="nav-header">Authentication</li>
            <li><a href="#authentication">Authorization and Authentication</a></li>
            % endif
          </ul>
        </div>

        <div class="well" id="data-model">
          <h3>Code my data model</h3>

          <p>When you want a model for storing favorite links or wiki content, the
          <code>/model</code> folder in your site is ready to go.</p>

          <p>You can build a dynamic site without any data model at all. There still be a
          default data-model template for you if you didn't enable authentication and
          authorization in quickstart. If you have enabled authorization, the auth
          data-model is ready-made.</p>
        </div>

        <div class="well" id="url-structure">
          <h3>Design my URL structure</h3>

          <p>The "<code>root.py</code>" file under the <code>/controllers</code> folder has
          your URLs. When you called this url (<code><a href=
          "${tg.url('/about')}">about</a></code>), the command went through the
          RootController class to the <code>about()</code> method.</p>

          <p>Those Python methods are responsible to create the dictionary of variables
          that will be used in your web views (template).</p>
        </div>

        <div class="well" id="template-reuse">
            <h3>Reuse the web page elements</h3>

            <p>A web page viewed by user could be constructed by single or several reusable
                templates under <code>/templates</code>.
                Each projects gets quickstarted with a <strong><span class="label label-info">master.html</span></strong>
                template and a bunch of templates for the pages provided by the RootController.
            </p>
        </div>
      </div>

      <div class="col-md-8">
        <img src="http://www.turbogears.org/2.1/docs/_images/tg2_files.jpg"
             alt="TurboGears2 quickstarted project" />
      </div>
    </div>

    <div class="row">
      <div class="col-md-12">
        <h3>The Master Template</h3>

        <p>The <strong><span class="label label-info">master.html</span></strong> template
        controls the overall design of the page we're looking at. It draws the headers,
        the footer, the notices flash and embeds the content of each page of your web applications.
        Thus the "master.html" template provides the overall architecture for
        each page in this site.</p>

        <p>There's more to the "master.html" template... study it to see how the
        &lt;title&gt; tags and static JS and CSS files are brought into the page.
        Templating with Genshi is a powerful tool and we've only scratched the surface.
        There are also a few little CSS tricks hidden in these pages, like the use of a
        "clearingdiv" to make sure that your footer stays below the sidebars and always
        looks right. That's not TG2 at work, just CSS. You'll need all your skills to
        build a fine web app, but TG2 will make the hard parts easier so that you can
        concentrate more on good design and content rather than struggling with
        mechanics.</p>
      </div>
    </div>

    % if tg.auth_stack_enabled:
    <div class="row">
      <div class="col-md-12" id="authentication" >
        <h3>Authentication &amp; Authorization in a TG2 site.</h3>

        <p>If you have access to this page, this means you have enabled authentication
        and authorization in the quickstart to create your project.</p>

        <p>The gearbox command will have created a few specific controllers for you. But
        before you go to play with those controllers you'll need to make sure your
        application has been properly bootstapped. This is dead easy, here is how to do
        this:</p>
        <pre>gearbox setup-app</pre>

        <p>inside your application's folder and you'll get a database setup (using the
        preferences you have set in your development.ini file). This database will also
        have been prepopulated with some default logins/passwords so that you can test
        the secured controllers and methods.</p>

        <p>To change the comportement of this setup-app command you just need to edit
        the <code>websetup.py</code> file.</p>

        <p>Now try to visiting the <a href=
        "${tg.url('/manage_permission_only')}">manage_permission_only</a> URL. You will
        be challenged with a login/password form.</p>

        <p>Only managers are authorized to visit this method. You will need to log-in
        using:</p>
        <pre>login: manager
password: managepass</pre>

        <p>Another protected resource is <a href=
        "${tg.url('/editor_user_only')}">editor_user_only</a>. This one is protected by
        a different set of permissions. You will need to be <code>editor</code> with a
        password of <code>editpass</code> to be able to access it.</p>

        <p>The last kind of protected resource in this quickstarted app is a full so
        called <a href="${tg.url('/secc')}">secure controller</a>. This controller is
        protected globally. Instead of having a @require decorator on each method, we
        have set an allow_only attribute at the class level. All the methods in this
        controller will require the same level of access. You need to be manager to
        access <a href="${tg.url('/secc')}">secc</a> or <a href=
        "${tg.url('/secc/some_where')}">secc/some_where</a>.</p>
      </div>
    </div>
    % endif

