#!/usr/bin/python
# -*- coding: utf-8 -*-

# thumbor imaging service
# https://github.com/globocom/thumbor/wiki

# Licensed under the MIT license:
# http://www.opensource.org/licenses/mit-license
# Copyright (c) 2012 Damien Hardy dhardy@figarocms.fr

from distutils.core import setup
from thumbor_riak import __version__

setup(
    name = "thumbor_riak",
    packages = ["thumbor_riak"],
    version = __version__,
    description = "Riak image storage for Thumbor",
    author = "Damien Hardy",
    author_email = "dhardy@viadeoteam.com",
    keywords = ["thumbor", "riak", "basho", "images"],
    license = 'MIT',
    url = 'https://github.com/dhardy92/thumbor_riak',
    classifiers = ['Development Status :: 4 - Beta',
                   'Intended Audience :: Developers',
                   'License :: OSI Approved :: MIT License',
                   'Natural Language :: English',
                   'Operating System :: POSIX :: Linux',
                   'Programming Language :: Python :: 2.6',
                   'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
                   'Topic :: Multimedia :: Graphics :: Presentation'
    ],
    package_dir = {"thumbor_riak": "thumbor_riak"},
    install_requires=["thumbor>=3.3.0"],
    long_description = """\
Thumbor is a smart imaging service. It enables on-demand crop, resizing and flipping of images.
This module provide support for Riak, a large auto replicant key/value backend edited by basho, to store Thumbor images.
"""
)
