import json
import urllib
from urlparse import urlparse, urlunparse
from copy import copy

from zope.interface import implements

from twisted.web.client import getPage
from twisted.internet import defer
from twisted.plugin import IPlugin
from twisted.python import log

from apiserver.interfaces import IBackend
from apiserver.utils import path_depth


class SDFSBackend(object):
    implements(IBackend, IPlugin)
    
    name = 'sdfs'
    
    path = None
    levels = None
    url = None
    id = None
    
    def __call__(self, section, node, section_config):
        self = copy(self)
        self.id = node['id']
        self.url = node['url'].rstrip('/')
        self.path = section_config['path'].strip('/')
        self.levels = {}
        self.levels.update(section.levels)
        if 'levels' in section_config:
            self.levels.update(section_config['levels'])
        return self
    
    def _getPage(self, url, method='GET'):
        scheme, netloc, path, params, query, fragment = urlparse(url)
        netloc = netloc.split('@')
        userpass = netloc.pop(0)
        url = urlunparse((scheme, netloc.pop(0), path, params, query, fragment))
        return getPage(url, headers={"Authorization": 'Basic %s' % userpass.encode('base64').strip()}, method=method)
    
    @defer.inlineCallbacks
    def list(self, path):
        path = path.strip('/')
        depth = path_depth(path)
        
        if depth in self.levels:
            depth = self.levels[depth]['depth']
        else:
            depth = 0
        
        actual_path = '%s/%s' % (self.path, path)
        url = '%s/%s' % (self.url, '/'.join(['list', urllib.quote(actual_path)]).replace('//', '/'))
        url = '%s?depth=%s' % (url, depth)
        result = yield self._getPage(url)
        if not result:
            log.err('Nothing found at path %s' % path)
            defer.returnValue(None)
        
        result = json.loads(result)
        items = {}
        for p, item_list in result['items'].iteritems():
            p = p[len(result['virtual_path'])+1:]
            
            for item in item_list:
                item['type'] = item['type'] == 1 and 'folder' or 'file'
                item['path'] = ('%s/%s' % (p, item['name'])).strip('/')
            items[p] = item_list
        
        result['items'] = items
        defer.returnValue(result)
    
    def stream(self, path):
        path = path.strip('/')
        actual_path = '%s/%s' % (self.path, path)
        url = '%s/%s' % (self.url, '/'.join(['stream', urllib.quote(actual_path)]).replace('//', '/'))
        return self._getPage(url, method='POST')

sdfsbackend = SDFSBackend()
#
#@defer.inlineCallbacks
#def list_folder(section, path, depth=0):
#    result = []
#    section_info = settings.SECTIONS[section]
#    for node in section_info['nodes']:
#        proxy = xmlrpc.Proxy(node['settings']['url'])
#        result.append(proxy.callRemote('get_uri',  'list://0/%s/%s?depth=%s' % (urllib.quote(node['sections'][section]['path'].strip('/')), urllib.quote(path.strip('/')), depth)))
#    
#    retval = []
#    result = yield defer.DeferredList(result)
#    for node, result in zip(settings.SECTIONS[section]['nodes'], result):
#        if not result[0]:
#            continue
#        
#        retval.append((node, result[1][1]))
#    
#    yield defer.returnValue(retval)
#
#
#@defer.inlineCallbacks
#def stream_item(section, path, node):
#    proxy = xmlrpc.Proxy(node['settings']['url'])
#    result = yield proxy.callRemote('get_uri',  'stream://0/%s/%s' % (urllib.quote(node['sections'][section]['path'].strip('/')), urllib.quote(path.strip('/'))))
#    yield defer.returnValue(result)