import sqlite3
import shelve
import atexit

from twisted.enterprise import adbapi

from apiserver import settings

def dict_factory(cursor, row):
    d = {}
    for idx, col in enumerate(cursor.description):
        d[col[0]] = row[idx]
    return d

def set_dict_and_unicode_factory(conn):
    conn.row_factory = dict_factory
    conn.text_factory = sqlite3.OptimizedUnicode

dbpool = adbapi.ConnectionPool('sqlite3', settings.DB_FILE, check_same_thread=False, cp_max=1, cp_min=1, cp_openfun=set_dict_and_unicode_factory)
metadata_db = shelve.open(settings.METADATA_FILE)

def shutdown_db():
    metadata_db.close()

atexit.register(shutdown_db)