from zope.interface import implements

from twisted.plugin import IPlugin
from twisted.internet import defer

from apiserver.db import dbpool
from apiserver.cache import cache
from apiserver.interfaces import IMetadata


class HistoryMetadata(object):
    implements(IPlugin, IMetadata)
    trigger = 'name'
    id = 'history'

    @defer.inlineCallbacks
    def handle_item(self, user, item, raw_item):
        key = 'history:%s' % user.username
        
        if key not in cache:
            result = yield dbpool.runQuery("SELECT item, watch_date FROM history WHERE user = ?", (user.username, ))
            cache[key] = dict((r['item'], r['watch_date']) for r in result)
        
        history = cache[key]
        item['watched'] = item['name'] in history
        defer.returnValue(item)

historymetadata = HistoryMetadata()