from twisted.web.resource import Resource as TwistedResource, _computeAllowedMethods
from twisted.web import server, guard, static
from twisted.internet import defer

from apiserver.users import User
from apiserver.utils import inject_allow_control_headers
from apiserver import settings

class TidalStreamOPTIONS(TwistedResource):
    isLeaf = True
    
    def render(self, request):
        inject_allow_control_headers(request)
        return ''


class TidalStreamHTTPAuthSessionWrapper(guard.HTTPAuthSessionWrapper):
    def getChildWithDefault(self, path, request):
        if request.method == 'OPTIONS':
            return TidalStreamOPTIONS()
        elif path == 'files' and settings.DATA_PATH:
            return static.File(settings.DATA_PATH) # move, bitch
        
        if 'token' in request.args and not request.requestHeaders.hasHeader('authorization'):
            request.requestHeaders.setRawHeaders('authorization', ['Token %s' % request.args['token'][0]])
            del request.args['token']
        
        request.postpath.insert(0, request.prepath.pop())
        return self._authorizedResource(request)


class Resource(TwistedResource):
    content_type = 'application/vnd.tidalstream+json'
    
    def getChildWithDefault(self, path, request):
        request.setHeader('content-type', self.content_type)
        request = inject_allow_control_headers(request)
        request.__dict__['user'] = User(request.getUser())
        return TwistedResource.getChildWithDefault(self, path, request)
    
    def render(self, request):
        """
        Adds support for deferred render methods
        """
        m = getattr(self, 'render_' + request.method, None)
        if not m:
            # This needs to be here until the deprecated subclasses of the
            # below three error resources in twisted.web.error are removed.
            from twisted.web.error import UnsupportedMethod
            allowedMethods = (getattr(self, 'allowedMethods', 0) or
                              _computeAllowedMethods(self))
            raise UnsupportedMethod(allowedMethods)
        
        result = defer.maybeDeferred(m, request)
        
        def write_rest(defer_result, request):
            request.write(defer_result)
            request.finish()
        
        def err_rest(defer_result=None):
            defer_result.printTraceback()
            request.finish()
        
        result.addCallback(write_rest, request)
        result.addErrback(err_rest)
        
        return server.NOT_DONE_YET