import re

from zope.interface import implements

from twisted.plugin import IPlugin

from apiserver.sections import SectionResource
from apiserver.interfaces import ISection


class AnimeSectionResource(SectionResource):
    implements(IPlugin, ISection)
    
    name = 'anime'
    levels = {
        0: {
            'content_type': 'tvshows',
            'depth': 0,
            'indexable': True,
        },
        1: {
            'content_type': 'episodes',
            'stream_depth': 0,
            'depth': 0,
            'overwrite_title': False,
        }
    }
    
    def sort(self, items, order_by):
        cache = {}
        ep_extractor = re.compile(r'[-_ .\[(](?:ep)?(\d+)[-_ .\])v]', re.IGNORECASE)
        
        def ep_extract(ep):
            ep_num = ep_extractor.findall(ep)
            if not ep_num:
                return ep
            
            return ep_num[0], ep
        
        def cmp_ep(a, b):
            if a['rel'] == b['rel'] != 'file':
                return cmp(a['name'].lower(), b['name'].lower())
            
            elif a['rel'] != b['rel'] == 'file':
                return -1
            
            elif b['rel'] != a['rel'] == 'file':
                return 1
            
            else:
                a = a['name'].replace(' ', '_')
                b = b['name'].replace(' ', '_')
            
            if a in cache:
                a_ep_nums = cache[a]
            else:
                a_ep_nums = cache[a] = ep_extract(a)
            
            if b in cache:
                b_ep_nums = cache[b]
            else:
                b_ep_nums = cache[b] = ep_extract(b)
            
            return cmp(a_ep_nums, b_ep_nums)
        
        if order_by == 'name':
            items.sort(cmp=cmp_ep)
        else:
            super(AnimeSectionResource, self).sort(items, order_by)
    
    def filter(self, items):
        to_delete = []
        for item in items:
            if item['name'].lower().endswith('.nfo') or item['name'].lower() == 'extra':
                to_delete.append(item)
        
        for item in to_delete:
            items.remove(item)
    
animesectionresource = AnimeSectionResource()