import json
import urlparse

from twisted.web import resource

from apiserver import settings
from apiserver.resource import Resource

class RootResource(Resource):
    def __init__(self):
        Resource.__init__(self)
        self.putChild('', self)
        for service in settings.SERVICES:
            if not resource.IResource.providedBy(service):
                continue
            
            self.putChild(service.name, service)
    
    def render_GET(self, request):
        return json.dumps({
            'motd': 'Welcome %s, this is a TidalStream API server' % request.getUser(),
            'sections': {
                'rel': 'stream_list',
                'href': urlparse.urljoin(settings.BASE_URL, '/section')
            }
        })
        