import json

from zope.interface import implements

from twisted.internet import defer
from twisted.plugin import IPlugin, getPlugins
from twisted.web import resource

from apiserver.interfaces import IService, IMetadata
from apiserver.resource import Resource
from apiserver import settings
from apiserver.utils import SmartEncoder

import apiserver.metadata
metadata_handlers = list(getPlugins(IMetadata, apiserver.metadata))

def get_metadata_handler(metadata_type):
    for m in metadata_handlers:
        if m.id == metadata_type:
            return m
    return None

class MetadataService(Resource):
    implements(IPlugin, IService)
    name = 'metadata'
    isLeaf = True
    
    def render_GET(self, request):
        if 1 > len(request.postpath) > 3:
            return resource.ErrorPage(500, 'Malformed request', 'The request you sent is malformed').render(request)
        
        metadata_type = request.postpath[0]
        metadata_handler = get_metadata_handler(metadata_type)
        
        if not metadata_handler:
            return resource.ErrorPage(500, 'Unknown metadata handler', 'The metadata handler you specified is currently very unknown, my main man.').render(request)
        
        if len(request.postpath) == 1:
            request.responseHeaders.setRawHeaders('Cache-Control', ['max-age=%s' % settings.METADATA_CACHE_TIME])
            return json.dumps(metadata_handler.get_obj_list(), cls=SmartEncoder)
        elif len(request.postpath) == 2:
            obj_id = request.postpath[1]
            obj = metadata_handler.get_obj(obj_id)
            if len(obj.keys()) > 1:
                request.responseHeaders.setRawHeaders('Cache-Control', ['max-age=%s' % settings.METADATA_CACHE_TIME])
            return json.dumps(obj, cls=SmartEncoder)
        
        return json.dumps({})
    
    @defer.inlineCallbacks
    def listing_result_item(self, section, user, path, item):
        raw_item = item['_original_item']
        for m in metadata_handlers:
            if m.trigger in raw_item:
                yield m.handle_item(user, item, raw_item)
    
metadataservice = MetadataService()