"""IT WILL SWALLOW YOU WHOLE"""
import json
import urlparse
import urllib

from zope.interface import implements

from twisted.web.resource import Resource as TwistedResource, NoResource
from twisted.plugin import IPlugin

from apiserver.interfaces import IService
from apiserver.resource import Resource
from apiserver import settings

class SectionResource(Resource):
    isLeaf = True
    
    def __init__(self, section):
        self.section = section
        Resource.__init__(self)
    
    def render_GET(self, request):
        return self.section.list(request.user, '/'.join(request.postpath), dict((key, value[0]) for key, value in request.args.iteritems()))
    
    def render_POST(self, request):
        return self.section.stream(request.user, '/'.join(request.postpath), dict((key, value[0]) for key, value in request.args.iteritems()))


class SectionHandlerResource(TwistedResource):
    implements(IPlugin, IService)
    name = 'section'
    
    def getChild(self, path, request):
        p = urllib.unquote(path)
        if p not in settings.SECTIONS:
            return NoResource()
        
        return SectionResource(settings.SECTIONS[path])
    
    def render_GET(self, request):
        return json.dumps({
            'name': 'Sections',
            'title': 'Sections',
            'rel': 'folder',
            'href': urlparse.urljoin(settings.BASE_URL, '/section'),
            'result': [{
                'name': name,
                'rel': 'folder',
                'href': urlparse.urljoin(settings.BASE_URL, '/section/%s' % urllib.quote(name))
                } for name, section in sorted(settings.SECTIONS.items())]
        })

# so fucking meta
sectionhandlerresource = SectionHandlerResource()