import json

from zope.interface import implements

from twisted.internet import defer
from twisted.plugin import IPlugin, getPlugins
from twisted.web import resource
from twisted.python.randbytes import secureRandom

from apiserver.interfaces import IService, IMetadata
from apiserver.resource import Resource
from apiserver.utils import SmartEncoder
from apiserver import settings
from apiserver.cache import cache

class TokenAuthService(Resource):
    implements(IPlugin, IService)
    name = 'tokenauth'
    isLeaf = True
    
    def render_GET(self, request):
        token = secureRandom(16).encode('hex')
        cache['auth:%s' % token] = request.user.username
        
        return json.dumps({
            'rel': 'token_auth',
            'token': token,
        })
    
tokenauthservice = TokenAuthService()