from datetime import timedelta

from zope.interface import implements

from twisted.cred import credentials, error, checkers
from twisted.web.iweb import ICredentialFactory
from twisted.internet import defer

from apiserver.cache import cache

class ITokenPassword(credentials.ICredentials):
    def checkToken(token):
        """
        Werkz
        """

class TokenPassword:
    implements(ITokenPassword)

    def __init__(self, token, request):
        self.username = None
        self.request = request
        self.token = token

    def checkToken(self, token):
        token = 'auth:%s' % token
        if token in cache:
            self.request.user = self.username = cache[token]
            return True
        return False

class TokenPasswordChecker:
    implements(checkers.ICredentialsChecker)

    credentialInterfaces = (ITokenPassword, )

    def requestAvatarId(self, credentials):
        if credentials.checkToken(credentials.token):
            return defer.succeed(credentials.username)
        else:
            return defer.fail(error.UnauthorizedLogin())

class InternalTokenAuthFactory(object):
    implements(ICredentialFactory)

    scheme = 'token'

    def getChallenge(self, request):
        return {}

    def decode(self, response, request):
        return TokenPassword(response, request)