import json
from decimal import Decimal

from datetime import datetime, date


def inject_allow_control_headers(request):
    origin = request.requestHeaders.getRawHeaders('origin')
    if origin:
        request.setHeader('access-control-allow-origin', origin[0])
    
    methods = request.requestHeaders.getRawHeaders('access-control-request-method')
    if methods:
        request.setHeader('access-control-allow-methods', 'POST, GET, OPTIONS')
    
    headers = request.requestHeaders.getRawHeaders('access-control-request-headers')
    if headers:
        request.setHeader('access-control-allow-headers', headers[0])
    
    if origin or methods or headers:
        request.setHeader('access-control-max-age', "1728000")
    
    return request

def path_depth(path):
    return 0 if len(path) == 0 else len(path.split('/'))

class SmartEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime) or isinstance(obj, date):
            return obj.isoformat()
        
        if isinstance(obj, Decimal):
            return float(obj)
        
        return json.JSONEncoder.default(self, obj)