import json
from urlparse import urlparse, urlunparse

from twisted.web import xmlrpc
from twisted.internet import defer

from apiserver.backends.sdfs import SDFSBackend

class OldSDFSBackend(SDFSBackend):
    name = 'oldsdfs'
    
    @defer.inlineCallbacks
    def _getPage(self, url, method='GET'):
        scheme, netloc, path, params, query, fragment = urlparse(url)
        url = urlunparse((scheme, netloc, '/', '', '', ''))
        
        path = '/'.join(path.strip('/').split('/')[1:])
        
        if method == 'GET':
            u = 'list://0/%s/?%s' % (path, query)
        elif method == 'POST':
            u = 'stream://0/%s' % path
        
        proxy = xmlrpc.Proxy(url)
        result = yield proxy.callRemote('get_uri', u)
        result = result[1]
        if method == 'POST':
            result = {'url': result}
        defer.returnValue(json.dumps(result))

oldsdfsbackend = OldSDFSBackend()