from datetime import datetime, timedelta

class Cache(object):
    _cache = None
    
    def __init__(self):
        self._cache = {}
    
    def __getitem__(self, key):
        return self.get(key)
    
    def __setitem__(self, key, value):
        return self.set(key, value)
    
    def __contains__(self, key):
        self.cleanup()
        return key in self._cache
    
    def get(self, key):
        if key in self._cache:
            value, timeout, timeout_delta = self._cache[key]
            if datetime.now() < timeout:
                return value
            
            del self._cache[key]
        
        self.cleanup()
        return None
    
    def set(self, key, value, timeout=None):
        if key in self._cache and timeout is None:
            timeout = self._cache[key][2]
        else:
            timeout = timedelta(minutes=10)
        
        self._cache[key] = (value, datetime.now()+timeout, timeout)
        self.cleanup()
    
    def cleanup(self):
        keys_to_delete = []
        for key, (value, timeout, timeout_delta) in self._cache.iteritems():
            if timeout < datetime.now():
                keys_to_delete.append(key)
        
        for key in keys_to_delete:
            del self._cache[key]

cache = Cache()