from zope.interface import Interface, Attribute

class ISection(Interface):
    """
    Sections are preparing what's shown to the user.
    """
    
    name = Attribute("Name of plugin")
    
    def list(section, path):
        """
        Lists the folder at path.
        """
    
    def stream(section, path):
        """
        Retrieves the stream at path.
        """

class IBackend(Interface):
    """
    Backends generates listings and retrieves actual content.
    
    These can be used by frontends.
    """
    
    name = Attribute("Name of plugin")
    
    def list(node, section, path):
        """
        Lists a path in section.
        """
    
    def stream(node, section, path):
        """
        Streams from path in section.
        """

class IMetadata(Interface):
    """
    Adds metadata to a listing after an IFrontend created it.
    """

class IService(Interface):
    pass