import os
from urlparse import urljoin

from twisted.internet import defer
from twisted.python import log
from twisted.web.client import downloadPage

from apiserver.db import metadata_db
from apiserver import settings

class SimpleMetadata(object):
    currently_fetching = False
    
    def keyify(self, t, id):
        return str('%s:%s:%s' % (self.id, t, id))
    
    @defer.inlineCallbacks
    def download_cover(self, obj_id, cover_url):
        image_file = None
        cover_path = None
        if settings.DATA_PATH is not None and cover_url:
            log.msg('%s Found cover for %s' % (self.id, obj_id))
            obj_path = os.path.join(settings.DATA_PATH, self.id)
            if not os.path.isdir(obj_path):
                os.mkdir(obj_path)
            
            image_file = '%s.%s' % (obj_id, cover_url.split('.')[-1])
            
            cover_path = os.path.join(obj_path, image_file.lower())
            if not os.path.isfile(cover_path):
                try:
                    yield downloadPage(str(cover_url), cover_path)
                except:
                    pass
        defer.returnValue(image_file)
    
    def fetch_metadata(self, obj_id):
        raise NotImplemented()
    
    @defer.inlineCallbacks
    def check_for_work(self):
        if self.currently_fetching:
            defer.returnValue(None)
        
        self.currently_fetching = True
        while metadata_db[self.keyify('d', 'queue')]:
            obj_id = metadata_db[self.keyify('d', 'queue')][0]
            metadata_db[self.keyify('d', 'queue')] = metadata_db[self.keyify('d', 'queue')][1:]
            if self.keyify('m', obj_id) in metadata_db:
                log.msg('%s Skipping %s' % (self.id, obj_id))
                continue
            
            log.msg('Fetching %s info for %s' % (self.id, obj_id))
            
            # timeout of 10minutes
           
            metadata_db[self.keyify('m', obj_id)] = yield self.fetch_metadata(obj_id)
            metadata_db[self.keyify('d', 'items')] = metadata_db.get(self.keyify('d', 'items'), []) + [obj_id]
            metadata_db.sync()
            
            log.msg('Fetched %s info for %s' % (self.id, obj_id))
        
        self.currently_fetching = False
    
    def get_cover_url(self, filename):
        return urljoin(settings.BASE_URL, 'files/%s/%s' % (self.id, filename))
    
    def get_url(self, obj_id):
        return urljoin(settings.BASE_URL, '/metadata/%s/%s' % (self.id, obj_id))
    
    def get_obj(self, obj_id):
        result = metadata_db.get(self.keyify('m', obj_id), {})
        result['href'] = self.get_url(obj_id)
        if result.get('cover', None):
            result['cover'] = self.get_cover_url(result['cover'])
        return result
    
    def get_obj_list(self):
        return [obj for obj in [self.get_obj(obj_id) for obj_id in metadata_db[self.keyify('d', 'items')]] if len(obj.keys()) > 1]
    
    def handle_item(self, user, item, raw_item):
        if self.keyify('d', 'queue') not in metadata_db:
            metadata_db[self.keyify('d', 'queue')] = []
        
        obj_id = raw_item[self.trigger].split(':')[0]
        if self.keyify('m', obj_id) not in metadata_db:
            if obj_id not in metadata_db[self.keyify('d', 'queue')]:
                metadata_db[self.keyify('d', 'queue')] = metadata_db[self.keyify('d', 'queue')] + [obj_id]
            self.check_for_work()
        
        item['metadata'] = {
            'rel': 'metadata',
            'id': obj_id,
            'type': self.id,
            'href': self.get_url(obj_id),
        }