""""
Jeg vil sA gerne kOre en traktor
"""

import re
import json
from urlparse import urljoin
from copy import copy
import urllib
from collections import defaultdict
from functools import partial

from twisted.internet import defer

from apiserver import settings
from apiserver.utils import path_depth
from apiserver.service import get_services

class SectionResource(object):
    cache_time = 60*10
    
    extra_folder = None
    
    def __call__(self, section_id, cfg):
        self = copy(self)
        self.nodes = []
        self.id = section_id
        
        extra_folder = cfg.get('extra_folder', self.extra_folder)
        if extra_folder:
            self.extra_folder = re.compile(extra_folder)
    
        if 'levels' in cfg:
            self.levels = self.levels.copy()
            for level, level_config in cfg['levels'].iteritems():
                if level in self.levels:
                    self.levels[level] = self.levels[level].copy()
                    self.levels[level].update(level_config)
                else:
                    self.levels[level] = level_config
        
        return self
    
    def filter(self, items):
        to_delete = []
        for item in items:
            if item['name'].lower().endswith('.nfo'):
                to_delete.append(item)
        
        for item in to_delete:
            items.remove(item)
    
    def _sort_key(self, order_by, v):
        if isinstance(v, dict):
            v = v.get(order_by, None)
        
        if type(v) in (str, unicode):
            return v.lower().lstrip('"([\'')
        return v
    
    def sort(self, items, order_by):
        items.sort(key=partial(self._sort_key, order_by))
    
    def clean_items(self, items):
        for item in items:
            if '_original_item' not in item:
                continue
            del item['_original_item']
    
    def _create_item(self, rel, href, date, name, original_item):
        return {
            'rel': rel,
            'href': href,
            'date': date,
            'name': name,
            '_original_item': original_item, # used by various plugins
        }
    
    def merge_items(self, items):
        if len(items) == 1:
            return items[0]
        
        main_item = items[0]
        other_item = self.merge_items(items[1:])
        
        if 'metadata' in main_item and 'metadata' not in other_item:
            return main_item
        return other_item
    
    def get_level(self, level, exact=False):
        for i in range(level, -1, -1):
            if i in self.levels:
                return self.levels[level]
            elif exact:
                return None
        
        raise NotImplemented('You need some goddamn levels for a section to work')
    
    def get_services(self, f_name):
        return get_services(f_name)
    
    @defer.inlineCallbacks
    def list(self, user, path, config):
        level = path_depth(path)
        level_setup = self.get_level(level)
        
        path_pointers = defaultdict(list)
        root = []
        
        base_url = '/'.join(x for x in [
                urljoin(settings.BASE_URL, '/section'),
                urllib.quote(self.id),
                urllib.quote(path)]
            if x)
        
        if 'filter_paths' in config:
            config['filter_paths'] = [('/'.join(y.split('/')[:-1]), y.split('/')[-1]) for y in config['filter_paths']]
        
        @defer.inlineCallbacks
        def handle_listing(listing, node):
            for folder, items in listing['items'].iteritems():
                for item in items:
                    relative_parent_path = '/'.join(item['path'].split('/')[:-1])
                    item_path = '/'.join(x for x in [path.decode('utf-8'), item['path']] if x)
                    
                    href = '%s/%s' % (base_url, urllib.quote(item['path'].encode('utf-8')))
                    rel = 'file'
                    
                    if 'stream_depth' in level_setup and level_setup['stream_depth'] < path_depth(relative_parent_path) and item['type'] == 'file':
                        continue
                    
                    if 'stream_depth' not in level_setup or level_setup['stream_depth'] >= path_depth(item['path']) or self.extra_folder and self.extra_folder.match(item['name']):
                        rel = 'folder'
                    else:
                        href += '?node=%s' % node.id
                    
                    item_data = self._create_item(rel, href, item['modified'], item['name'], item)
                    
                    for f in self.get_services('listing_result_item'):
                        yield defer.maybeDeferred(f, self, user, item_path, item_data)
                    path_pointers[relative_parent_path].append(item_data)
            
            item_data = self._create_item('folder', base_url, listing['modified'], listing['name'], item)
            for f in self.get_services('listing_result_item'):
                yield defer.maybeDeferred(f, self, user, '', item_data)
            root.append(item_data)
            
        d = []
        for node in self.nodes:
            d.append(defer.maybeDeferred(node.list, path).addCallback(handle_listing, node))
        
        yield defer.DeferredList(d)
        
        for f in self.get_services('listing_result'):
            yield defer.maybeDeferred(f, self, user, path, path_pointers)
        
        # the first listing is fast for scanning and adding new elements
        #
        # the final listing is good for browsing around and solves some short-comings
        # that the other listing suffers from
        root = self.merge_items(root)
        root['result'] = []
        root['overwrite_title'] = self.levels.get(level, {}).get('overwrite_title', True)
        if level == 0:
            root['name'] = self.id
        
        item_pointer = {'': root}
        for item_parent_path in sorted(path_pointers.keys()):
            items = path_pointers[item_parent_path]
            
            for item in items:
                if 'filter_paths' in config and (item_parent_path, item['name']) not in config['filter_paths']:
                    continue
                
                if item['rel'] == 'file':
                    if 'result' not in item_pointer[item_parent_path]:
                        item_pointer[item_parent_path]['result'] = []
                        item_pointer[item_parent_path]['overwrite_title'] = root['overwrite_title']
                    
                    item_pointer[item_parent_path]['result'].append(item)
                
                elif item['rel'] == 'folder':
                    if item_parent_path:
                        item_path = '%s/%s' % (item_parent_path, item['name'])
                    else:
                        item_path = item['name']
                    
                    if item_path in item_pointer:
                        item_pointer[item_path] = self.merge_items([item_pointer[item_path], item])
                    else:
                        item_pointer[item_path] = item
        
        # remove empty itamz
        
        for item_path in sorted(item_pointer.keys())[1:]:
            item = item_pointer[item_path]
            parent_item_path = '/'.join(item_path.split('/')[:-1])
            parent_item = item_pointer[parent_item_path]
            
            if 'result' not in parent_item:
                parent_item['result'] = []
            
            parent_item['result'].append(item)
        
        for items in item_pointer.values():
            if 'result' not in items:
                continue
            self.filter(items['result'])
            self.sort(items['result'], config.get('order_by', 'name'))
            self.clean_items(items['result'])
        
        del root['_original_item']
        
        if 'content_type' in level_setup:
            root['content_type'] = level_setup['content_type']
        
        defer.returnValue(json.dumps(root))
        
    @defer.inlineCallbacks
    def stream(self, user, path, config):
        node = [node for node in self.nodes if node.id == config['node']]
        if not node:
            defer.returnValue(json.dumps({'status': 'error', 'message': 'unknown node'}))
        node = node[0]
        
        result = json.loads((yield node.stream(path)))
        url = result['url']
        
        for f in self.get_services('stream_result'):
            url = f(user, path, url) or url
        
        defer.returnValue(json.dumps({
            'name': path.split('/')[-1],
            'href': url,
            'rel': 'http',
        }))