#import json
#import hmac
#import urllib
#from datetime import timedelta
#
#from twisted.web import client, resource
#from twisted.internet import defer
#from twisted.plugin import IPlugin
#
#from zope.interface import implements
#
#from apiserver import settings
#from apiserver.signer import sign_url
#from apiserver.resource import Resource
#from apiserver.section import SectionInterface
#from apiserver.cache import cache
#
#class LiveTVResource(Resource):
#    implements(IPlugin, SectionInterface)
#
#    isLeaf = True
#    name = 'Live TV'
#    id = 'livetv'
#
#    def _list_channels(self, section):
#        d = []
#        def add_node_name(result, node):
#            return defer.succeed((node, result))
#
#        for node in settings.SECTIONS[section]['nodes']:
#            url = sign_url(node['sections'][section]['psk'], node['settings']['url'])
#            d.append(client.getPage(url).addCallback(add_node_name, node))
#        d = defer.DeferredList(d)
#
#        def done_listing(result):
#            retval = []
#            for success, value in result:
#                if not success: continue
#                retval.append(value)
#            return defer.succeed(retval)
#
#        return d.addCallback(done_listing)
#
#    @defer.inlineCallbacks
#    def render_GET(self, request):
#        path = request.path.split('/')
#
#        section = urllib.unquote(path[2])
#        path = urllib.unquote('/'.join(path[3:]).strip('/'))
#
#        if path == '':
#            result = []
#            tv_channels = yield self._list_channels(section)
#            for node, tv_result in tv_channels:
#                for tv_channel in json.loads(tv_result):
#                    result.append({
#                        'title': tv_channel['name'],
#                        'href': settings.BASE_URL + '/section/%s/%s?node=%s' % (section, urllib.quote(tv_channel['name'].encode('utf-8')), node['name']),
#                        'rel': 'stream'
#                    })
#                
#            yield defer.returnValue(json.dumps({'data': result}))
#
#        request.setResponseCode(404)
#        yield defer.returnValue('')
#
#    def render_POST(self, request):
#        path = request.path.split('/')
#
#        section = urllib.unquote(path[2])
#        path = urllib.unquote('/'.join(path[3:]).strip('/'))
#
#        node = settings.NODES[request.args['node'][0]]
#        if section not in settings.SECTIONS or node not in settings.SECTIONS[section]['nodes']:
#            return resource.NoResource('Unknown Node').render(request)
#        
#        url = '%s%s' % (node['settings']['url'], urllib.quote(path))
#        
#        if node['sections'][section]['restrict-ip']:
#            url += '?ip=%s' % request.getClientIP()
#        
#        return json.dumps({
#            'href': sign_url(node['sections'][section]['psk'], url),
#            'rel': 'stream_data'
#        })
#
#livetvresource = LiveTVResource()
