import re

from zope.interface import implements

from twisted.plugin import IPlugin

from apiserver.sections import SectionResource
from apiserver.interfaces import ISection


class TVSectionResource(SectionResource):
    implements(IPlugin, ISection)
    
    name = 'tv'
    
    levels = {
        0: {
            'content_type': 'tvshows',
            'depth': 0,
        },
        1: {
            'content_type': 'episodes',
            'stream_depth': 1,
            'depth': 1,
            'overwrite_title': False,
        }
    }
    
    def sort(self, items, order_by):
        cache = {}
        ep_extractor = re.compile(r'.+[_.-](?:S(\d+)[_.-]?E(\d+)|(\d+)x(\d+))[E_.-]')
        
        def ep_extract(ep):
            ep_nums = ep_extractor.findall(ep)
            if not ep_nums:
                return 100, 100
            
            ep_nums = ep_nums[0]
            if ep_nums[0]:
                return int(ep_nums[0]), int(ep_nums[1])
            
            return int(ep_nums[2]), int(ep_nums[3])
        
        def cmp_ep(a, b):
            if a['rel'] == b['rel'] != 'file':
                return cmp(a['name'], b['name'])
            
            elif a['rel'] != b['rel'] == 'name':
                return -1
            
            elif b['rel'] != a['rel'] == 'name':
                return 1
            
            else:
                a = a['name']
                b = b['name']
            
            if a in cache:
                a_ep_nums = cache[a]
            else:
                a_ep_nums = cache[a] = ep_extract(a)
            
            if b in cache:
                b_ep_nums = cache[b]
            else:
                b_ep_nums = cache[b] = ep_extract(b)
            
            return cmp(a_ep_nums, b_ep_nums)
        
        if order_by == 'name':
            items.sort(cmp=cmp_ep)
        else:
            super(TVSectionResource, self).sort(items, order_by)

section = TVSectionResource()