from zope.interface import implements

from twisted.internet import defer
from twisted.plugin import IPlugin

from apiserver.interfaces import IService
from apiserver.db import dbpool
from apiserver.cache import cache

class HistoryService(object):
    implements(IPlugin, IService)
    name = 'history'
    
    def stream_result(self, user, path, url):
        item = path.split('/')[-1]
        def set_watched(txn):
            count = txn.execute("SELECT count(*) as num FROM history WHERE watch_date > datetime('now', '-1 days') AND user = ? AND item = ?", (user.username, item, )).fetchone()['num']
            if not count:
                txn.execute("INSERT INTO history (user, item, watch_date) VALUES (:user, :item, datetime('now'))", {
                    'user': user.username,
                    'item': item,
                })
        dbpool.runInteraction(set_watched)
    
    @defer.inlineCallbacks
    def listing_result_item(self, section, user, path, item):
        key = 'history:%s' % user.username
        
        if item['rel'] == 'file':
            if key not in cache:
                result = yield dbpool.runQuery("SELECT item, watch_date FROM history WHERE user = ?", (user.username, ))
                cache[key] = dict((r['item'], r['watch_date']) for r in result)
            
            history = cache[key]
            item['watched'] = item['name'] in history
        defer.returnValue(item)
    
historyservice = HistoryService()

def check_or_create_tables():
    dbpool.runOperation("""CREATE TABLE IF NOT EXISTS history (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user VARCHAR(50) NOT NULL,
        item VARCHAR(255) NOT NULL,
        watch_date DATETIME NOT NULL
    )""")

check_or_create_tables()