TidalStream SDFS
================

[![Build Status](https://travis-ci.org/JohnDoee/tidalstream-sdfs.png?branch=master)](https://travis-ci.org/JohnDoee/tidalstream-sdfs)

The Distributed "Filesystem" used as data backend for TidalStream
(not an actual filesystem)

More explanation
----------------

SDFS is basically just the underlying filesystem exposed through a RESTFUL server.
It also supports plugins.

Currently there are two builtin plugins exposed through the XMLRPC server, list and stream.
The list plugin can list folders and the stream plugin can start a stream and send back an
url to the requesting client.

There are a few other types of plugins, generic and metadata handler.

The generic ones are the ones like the http plugin that does not fit into a box, but are used by other
plugins to get them working.

The metadata handler plugins are the ones setting metadata on files and folders during scan, e.g. imdb,
it crawls the NFO and sets the imdb for the parent folder.

Prerequisite
------------

* Python 2.6+

There's a special requirement for the streaming module, it needs a few applications installed for it to work
with AVI stuff.
* unrar
* mkvmerge


Installation
------------

    virtualenv tidalstream-sdfs
    tidalstream-sdfs/bin/pip install git+https://github.com/JohnDoee/tidalstream-sdfs.git


Usage
-----

Download and edit sdfs.users and sdfs.conf to a directory, start using twistd sdfs in the directory
with the config and user file.


Settings
--------

### general

General configuration settings

* externalip - IP used in urls returned by SDFS to explain how to reach it and its resources
* controlport - Port used to control the SDFS for e.g. listing folders or starting a stream
* usessl - Use SSL on the control port
* certfile - If using SSL, which certificate to use (a path to the cert)
* userfile - A file containing all users in a user:password format
* rescan_crontab - Crontab syntax for how often to automatically rescan everything, if empty then no rescan is scheduled
* dbfile - Path to the database file where filelisting is saved

### disks

Where to find the data SDFS should index

These are named in a disk[number] pattern where number should start at 1 and increment by one
for each disk.

The prefix[number] is where the disk[number] is mapped to.

Example:
disk1=/home/johndoee/
prefix1=/johndoee/

In /home/johndoee/ there is a file called homework.doc, this file can be found through SDFS at the path /johndoee/homework.doc

Disk supports globs (e.g. /home/*/)

### plugin-stream

* resultpath - Where to unpack a stream when a packed streamable item is requested
* cleanup - Automatically cleanup resultpath, remove old items.


FAQ
---

Q: How do i easily rescan?
A: run: ```curl "http://apiserver1:QnyaVEwy@external.example.com:16683/rescan/" -d ""``` -- what it does is ask SDFS to run the command rescan

Q: How do i upgrade SDFS?
A: run: ```tidalstream-sdfs/bin/pip install --upgrade git+https://github.com/JohnDoee/tidalstream-sdfs.git``` -- This will reinstall SDFS and all the dependencies, thus making it the latest version.

License
-------
See LICENSE

Future plans
------------
Remove all GPL software, should be possible to use this in any setting

List of GPL software currently used
* hachoir
* mutagen
