from sdfs.utils import keyify

class MetadataMixin:
    """
    A mixing for plugins that enables them to easily set new metadata for an
    item correctly.
    """
    
    def set_metadata(self, item_type, virtual_path, key, value):
        """
        Sets new metadata for a given item.
        
        Parameters:
        
        - `item_type`: Type of item.
        - `virtual_path`: Virtual path to the item.
        - `key`: Key to set value for.
        - `value`: Value to set.
        """
        key = 'plugin:%s:%s' % (self.name, key)
        self.filesystem.set_metadata(item_type, virtual_path, key, value)