import urllib

from zope.interface import implements

from twisted.plugin import IPlugin

from sdfs.interfaces import IURIHandler
from sdfs.exceptions import FileOrFolderNotFoundException
from sdfs.resource import PluginResource

LIST_TEMPLATE = """<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
 <head>
  <title>Index of {{ virtual_path }}</title>
 </head>
 <body>
<h1>Index of {{ virtual_path }}</h1>
<table>
<thead><tr><th>Name</th><th>Size</th><th>Date</th></tr></thead>
<tbody>
{% for subitems in items.values() %}
{% for item in subitems %}
<tr><td>{% if item.type == 1 %}<a href="{{ item.name|urlencode }}/">{{ item.name }}</a>{% else %}{{ item.name }}{% endif %}</td><td>{{ item.size }}</td><td>{{ item.modified }}</td></tr>
{% endfor %}
{% endfor %}
</tbody>
</table>"""

class LISTURIHandler(PluginResource):
    implements(IPlugin, IURIHandler)
    
    name = 'list'
    scheme = 'list'
    
    def serialize_html(self, request, data):
        request.setHeader('content-type', 'text/html')
        
        from jinja2.sandbox import SandboxedEnvironment
        env = SandboxedEnvironment()
        env.filters['urlencode'] = urllib.quote_plus
        template = env.from_string(LIST_TEMPLATE)
        
        return str(template.render(data))
    
    def render_GET(self, request):
        depth = 0
        if 'depth' in request.args:
            depth = int(request.args['depth'][0])
        
        path = self.get_path(request)
        
        d = self.filesystem.list_dir([path], depth=depth)
        if d.values()[0] is None:
            raise FileOrFolderNotFoundException("'%s' not found" % path)
        
        for k, items in d.items():
            for item in items:
                if 'type' in item:
                    item['type'] = ord(item['type'])
        
        m = self.filesystem.get_metadata(path)
        m['items'] = d
        
        return m
    
    
listurihandler = LISTURIHandler()