import re
import os

from zope.interface import implements
from twisted.plugin import IPlugin

from sdfs.interfaces import IMetadata
from sdfs.enum import *
from sdfs.mixins import MetadataMixin

class MALURIHandler(object, MetadataMixin):
    implements(IPlugin, IMetadata)
    
    filetypes = re.compile(r'^mal\.nfo$')
    name = 'mal'
    
    def found_file(self, root, virtual_root, f):
        with open(os.path.join(root, f)) as fn:
            d = fn.read()
        ids = re.findall(r'[0-9]+', d)
        if ids:
            self.set_metadata(DatabaseType.DIRECTORY, virtual_root, 'id',
                              ':'.join(ids))

    
malurihandler = MALURIHandler()