tigreBrowser
============

Gene expression model browser for results from tigre R package
(http://www.bioconductor.org/packages/release/bioc/html/tigre.html).

tigreBrowser is licensed under GNU Affero General Public License (AGPL3)

tigreBrowser includes jQuery 1.4.2. (http://jquery.com/) licensed under MIT/GPL2 license

tigreBrowser includes jQuery Dynamic Form 1.0.3. (http://code.google.com/p/jquery-dynamic-form/) licensed under GPL3 license


Recent changes
==============

Version 1.0.3 (2014-01-28)
* File reorganisation to simplify database import from text files
* Add new options to control UI complexity

Version 1.0.2 (2011-09-20)
* Fix a bug in handling '_' in experiment names

Version 1.0.1 (2011-01-17)
* Miscellaneous bugfixes.

Version 1.0.0 (2010-10-08)
* Initial release.


Installation
============

tigreBrowser requires Python version >=2.5.
tigreBrowser can be installed with the following command:

```
python setup.py install
```

For more information about installing python modules (for example, installing
without root permissions for the current user only), see
http://docs.python.org/install/


Starting server
===============

The web server included in tigreBrowser must be running in order to use the
actual result browser.

You will need a database file generated by the tigre R package
(http://www.bioconductor.org/packages/release/bioc/html/tigre.html). This
package contains a test database file 'database.sqlite' which can be used to
test tigreBrowser. The test database was generated using the instructions and
example data included in tigre package.

Execute tigreServer.py to start the graphical user interface of the server. In
order to start the result browser, one must first select a database file of
which results will be shown. This can be accomplished by selecting 'Open
database file' and choosing a database file. The database file must not have
write permissions. The server can then be started by clicking 'Start server'.
When clicked, a label appears below the buttons to show the URL of the result
browser.

The result browser is now accessible in that URL using a regular web browser.
Instructions on using the browser are in the next section of this manual. The
browser is available until the server is stopped with the 'Stop server' button.

tigreServer.py can also be used with a command-line interface. Start the script
with `--help` option for more details.


Using the browser
=================

Dataset selection
-----------------

The dataset selection determines which results will be visible in the results
listing and in which order. The experiment set selection is used to select the
set of experiments. Only results from these experiments will be shown in the
listing.

Next in the dataset selection is the selection of transcription factor (TF) or
target set, depending on whether the result browser is set to Target ranking
mode or regulator ranking mode (see installation). In target ranking mode, the
TF selection is available and the results listing contains results for
different targets with the given TF. In regulator ranking mode, the target set
is selected and the listing will show results for different regulators.

As the number of results can be high, the results might be divided into multiple
pages. "Number of genes per page" selection can be used to adjust the number of
showed results. It can be useful to decrease the number of results if the page
loads slowly due to huge number of images.

Finally, the order in which the results are showed can be altered with the
"Sort by" selection. The results will be sorted descendingly by the given
criterion.


Filtering
---------

Results can be filtered by different criteria. One can, for example, show only
results for genes that have z-score higher than a certain threshold.

It is possible to combine multiple criteria when filtering. "[+]" link can be
used to add another criterion. A criterion can be likewise removed using "[-]"
link (not showed when there is only one criterion). When multiple criteria are
used, a gene result must meet all the criteria to be showed in the listing.

Filtering is activated using "Apply filters" checkbox.


Highlighting
------------

If genes in the database contain supplementary data, results can be highlighted
using that data. The available highlighting options are showed with the colors
associated to those options.

The highlighting works by showing colored boxes below the probe names in the
result listing for genes which have supplementary data that matches the
selection.


Search
------

It is possible to search results for the given genes. The search works by
typing comma separated list of gene or probe names to the search box. Gene
aliases can also be used as a search entry.


Displaying results
------------------

The results for the given selection of dataset, filters, highlights and search
will be showed when "Send" button is clicked. The database will then be queried
for results which match the given selection. "Reset" button can be used to
clear all selections and textfields.

The results listing contains multiple columns. In the first column a probe
name is displayed with a GENENAME associated with the probe. Next to the gene
name, is the gene expression figure if one is defined in the database. The
following column contains the actual results for genes. Any supplementary data
is also displayed here. Experiment figures will be displayed alongside the
result values.

Finally, experiment parameters, if inserted into the database, will be
displayed as a table next to the figures.
