import os
import sys
import hashlib
import urllib2
import socket

from flask import Flask, Response

from conf import TILES_STORAGE, MAP_SERVER

normpath = lambda *args: os.path.normpath(os.path.abspath(os.path.join(*args)))

def tilescache_wsgi(tiles_storage=None, map_server=None):
    if not tiles_storage:
        tiles_storage = os.environ.get("TILESCACHE_TILES_STORAGE", TILES_STORAGE)
    if not map_server:
        map_server = os.environ.get("TILESCACHE_MAP_SERVER", MAP_SERVER)

    app = Flask(__name__)

    @app.route("/")
    def home():
        return """<h1>tilescache</h1>
2013 <a href="http://ondrejsika.com">Ondrej Sika</a>, 
<a href="http://ondrejsika.com/docs/tilescache">homepage</a>"""

    @app.route("/tile/<s>/<z>/<x>/<y>.png")
    def tile(s, z, x, y):
        hash = hashlib.sha1("%s-%s-%s"%(z, y, x)).hexdigest()
        file_dir = normpath(tiles_storage, hash[0:4], hash[5:8], hash[9:12])
        file_path = normpath(file_dir, "%s.png"%hash[:12])

        if not os.path.exists(file_path):
            url = map_server.replace("{s}", s).replace("{z}", z).replace("{y}", y).replace("{x}", x)
            if not os.path.exists(file_dir):
                try:
                    os.makedirs(file_dir)
                except (OSError, IOError):
                    return Response("500 can't create dir", status=500)
            try:
                file_data = urllib2.urlopen(url, timeout=3).read()
            except (urllib2.URLError, socket.timeout):
                return Response("500 can't get file", status=500)
            try:
                file(file_path, "w").write(file_data)
            except (OSError, IOError):
                return Response("500 can't write file", status=500)
        else:
            try:
                file_data = file(file_path).read()
            except (OSError, IOError):
                return Response("500 can't read file", status=500)

        return Response(file_data, mimetype="image/png")

    return app

app = tilescache_wsgi()
