#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

""" Setup.py script """

from setuptools import setup

PROJECT = "timevortex"

PLUGIN = "currentcost"


########################################
# VERSION should stay in line 16
VERSION = "2.4.13"
########################################

INSTALL_REQS = [
    "pyserial >= 2.5",
    "argparse",
    "timevortex.messager",
    "timevortex.filestorage"]

setup(
    name="%s.%s" % (PROJECT, PLUGIN),
    version=VERSION,
    description="TimeVortex module that collect CurrentCost data.",
    long_description=open('README.rst').read(),
    author="Pierre Leray",
    author_email="pierreleray64@gmail.com",
    url="https://github.com/liogen/%s.%s" % (PROJECT, PLUGIN),
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Operating System :: Unix",
        "Programming Language :: Python :: 2.7",
        "Topic :: Home Automation",
        "License :: OSI Approved :: MIT License",
    ],
    packages=[PLUGIN],
    scripts=[
        "bin/%s-%s" % (PROJECT, PLUGIN),
        "bin/%s-writer" % PROJECT,
        "bin/%s-logextracter" % PROJECT],
    install_requires=INSTALL_REQS,
    zip_safe=False,
    data_files=[
        ('/opt/timevortex', ['logs/%s-%s.conf' % (PROJECT, PLUGIN)]),
        ('/opt/timevortex/data', ['data/.create_cc']),
        ('/var/log/timevortex', ['data/.create_cc']),
        ('/etc/udev/rules.d', ['udev/70-currentcost.rules']),
    ],
)
