#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# pylint: disable=C0103

"""Db adapter for timevortex project"""

import logging
import ConfigParser

BOOLEAN = "boolean"
INT = "int"
ARRAY = "array"
EMPTY = ""
TIMEVORTEX_SECTION = "timevortex"
TIMEVORTEX_CURRENTCOST_SECTION = "timevortex_currentcost"
TIMEVORTEX_TIMESERIESLOGGER_SECTION = "timevortex_timeserieslogger"
TIMEVORTEX_MESSAGER_SECTION = "timevortex_messager"
TIMEVORTEX_FILESTORAGE_SECTION = "timevortex_filestorage"
LOG_FILE_OPTION = "log_file"
ACTIVATE_TIMEVORTEX_CURRENTCOST_OPTION = "activate_timevortex_currentcost"
ACTIVATE_TV_TIMESERIESLOGGER_OPTION = "activate_timevortex_timeserieslogger"
SITE_ID_OPTION = "site_id"
VARIABLE_ID_OPTION = "variable_id"
CH1_W_OPTION = "ch1_w"
CH2_W_OPTION = "ch2_w"
CH3_W_OPTION = "ch3_w"
TMPR_OPTION = "tmpr"
TTY_PORT_OPTION = "tty_port"
TIMEOUT_CURRENTCOST_OPTION = "timeout_currentcost"
USB_RETRY_OPTION = "usb_retry"
ACTIVATE_DAILY_REPORT_OPTION = "activate_daily_report"
DAILY_REPORT_TARGET_OPTION = "daily_report_target"
DAILY_REPORT_SITE = "daily_report_site"
RABBITMQ_USERNAME_OPTION = "rabbitmq_username"
RABBITMQ_PASSWORD_OPTION = "rabbitmq_password"
RABBITMQ_HOST_OPTION = "rabbitmq_host"
GMAIL_USERNAME_OPTION = "gmail_username"
GMAIL_PASSWORD_OPTION = "gmail_password"
DATA_FOLDER_OPTION = "data_folder"


class Config(object):
    """Class that help us to read/write in main config file"""

    def __init__(self, config_path):
        """Constructor"""
        self.config_path = config_path
        self.logger = logging.getLogger("filestorage")
        self.config = ConfigParser.ConfigParser()
        self.config.read(config_path)

    def get(self, section, option, get_type=None):
        """Method that genericaly call a get on config file and catch
        mainly exception.
        """
        try:
            if get_type == BOOLEAN:
                element = self.config.getboolean(section, option)
                if element == EMPTY or element is None:
                    return False
            elif get_type == INT:
                element = self.config.getint(section, option)
                if element == EMPTY:
                    return None
            else:
                element = self.config.get(section, option)
                if element == EMPTY:
                    return None

            if get_type == ARRAY and element is not None:
                element = element.split(",")

            return element
        except ConfigParser.NoSectionError:
            if get_type is None or get_type == INT:
                return None
            elif get_type == BOOLEAN:
                return False
        except ConfigParser.NoOptionError:
            if get_type is None or get_type == INT:
                return None
            elif get_type == BOOLEAN:
                return False
        except ValueError:
            if get_type == BOOLEAN:
                return False
            return None

    def get_timevortex_log_file(self):
        """Return log file for timevortex script
        """
        return self.get(TIMEVORTEX_SECTION, LOG_FILE_OPTION)

    def get_activate_timevortex_currentcost(self):
        """Return is we should start timevortex-currentcost script.
        """
        return self.get(
            TIMEVORTEX_SECTION,
            ACTIVATE_TIMEVORTEX_CURRENTCOST_OPTION,
            BOOLEAN)

    def get_activate_timevortex_timeserieslogger(self):
        """Return is we should start timevortex-currentcost script.
        """
        return self.get(
            TIMEVORTEX_SECTION,
            ACTIVATE_TV_TIMESERIESLOGGER_OPTION,
            BOOLEAN)

    def get_currentcost_site_id(self):
        """Return site_id for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, SITE_ID_OPTION)

    def get_currentcost_variable_id(self):
        """Return variable_id for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, VARIABLE_ID_OPTION)

    def get_currentcost_ch1_w(self):
        """Return ch1_w for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, CH1_W_OPTION)

    def get_currentcost_ch2_w(self):
        """Return ch2_w for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, CH2_W_OPTION)

    def get_currentcost_ch3_w(self):
        """Return ch3_w for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, CH3_W_OPTION)

    def get_currentcost_tmpr(self):
        """Return tmpr for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, TMPR_OPTION)

    def get_currentcost_tty_port(self):
        """Return tty_port for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, TTY_PORT_OPTION)

    def get_currentcost_timeout(self):
        """Return timeout_currentcost for timevortex-currentcost
        """
        return self.get(
            TIMEVORTEX_CURRENTCOST_SECTION, TIMEOUT_CURRENTCOST_OPTION, INT)

    def get_currentcost_usb_retry(self):
        """Return usb_retry for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, USB_RETRY_OPTION, INT)

    def get_currentcost_log_file(self):
        """Return log_file for timevortex-currentcost
        """
        return self.get(TIMEVORTEX_CURRENTCOST_SECTION, LOG_FILE_OPTION)

    def get_timeserieslogger_activate_daily_report(self):
        """Return boolean daily_report activation
        """
        return self.get(
            TIMEVORTEX_TIMESERIESLOGGER_SECTION,
            ACTIVATE_DAILY_REPORT_OPTION,
            BOOLEAN)

    def get_timeserieslogger_daily_report_target(self):
        """Return daily-report target for timevortex_timeserieslogger
        """
        return self.get(
            TIMEVORTEX_TIMESERIESLOGGER_SECTION, DAILY_REPORT_TARGET_OPTION)

    def get_timeserieslogger_daily_report_site(self):
        """Return daily-report site for timevortex_timeserieslogger
        """
        return self.get(
            TIMEVORTEX_TIMESERIESLOGGER_SECTION, DAILY_REPORT_SITE, ARRAY)

    def get_timeserieslogger_log_file(self):
        """Return log_file for timevortex_timeserieslogger
        """
        return self.get(
            TIMEVORTEX_TIMESERIESLOGGER_SECTION, LOG_FILE_OPTION)

    def get_messager_rabbitmq_username(self):
        """Return rabbitmq_username for timevortex_messager
        """
        return self.get(TIMEVORTEX_MESSAGER_SECTION, RABBITMQ_USERNAME_OPTION)

    def get_messager_rabbitmq_password(self):
        """Return rabbitmq_password for timevortex_messager
        """
        return self.get(TIMEVORTEX_MESSAGER_SECTION, RABBITMQ_PASSWORD_OPTION)

    def get_messager_rabbitmq_host(self):
        """Return rabbitmq_host for timevortex_messager
        """
        return self.get(TIMEVORTEX_MESSAGER_SECTION, RABBITMQ_HOST_OPTION)

    def get_messager_gmail_username(self):
        """Return gmail_username for timevortex_messager
        """
        return self.get(TIMEVORTEX_MESSAGER_SECTION, GMAIL_USERNAME_OPTION)

    def get_messager_gmail_password(self):
        """Return gmail_password for timevortex_messager
        """
        return self.get(TIMEVORTEX_MESSAGER_SECTION, GMAIL_PASSWORD_OPTION)

    def get_filestorage_data_folder(self):
        """Return data_folder for timevortex_filestorage
        """
        return self.get(TIMEVORTEX_FILESTORAGE_SECTION, DATA_FOLDER_OPTION)
