#!/usr/bin/python
# -*- coding: utf8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-

""" Setup.py script """

from setuptools import setup

PROJECT = "timevortex"

INSTALL_REQS = [
    "argparse", "timevortex.currentcost", "timevortex.timeserieslogger"]

########################################
# VERSION should stay in line 16
VERSION = "0.4.8"
########################################

setup(
    name="%s" % (PROJECT),
    version=VERSION,
    description="Open source data logging platform for Internet of Things",
    long_description=open('README.rst').read(),
    author="Pierre Leray",
    author_email="pierreleray64@gmail.com",
    url="https://github.com/liogen/%s" % (PROJECT),
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Operating System :: Unix",
        "Programming Language :: Python :: 2.7",
        "Topic :: Home Automation",
        "License :: OSI Approved :: MIT License",
    ],
    packages=[PROJECT],
    scripts=["bin/%s" % (PROJECT)],
    install_requires=INSTALL_REQS,
    zip_safe=False,
    data_files=[
        ('/opt/timevortex', [
            'logs/%s.conf' % (PROJECT),
            'config/config.ini']),
        ('/etc/supervisor/conf.d', [
            'supervisor/timevortex.currentcost.conf',
            'supervisor/timevortex.timeserieslogger.conf']),
    ],
)
