"""
JSON Template is a minimal but powerful templating language implemented in multiple languages.

This extension requires: jsontemplate (http://code.google.com/p/json-template/)
"""
from setuptools import setup

setup(
    name = 'tipfy.ext.jsontemplate',
    version = '0.2.3',
    license = 'Apache',
    url = 'http://github.com/jurev/tipfy-jsontemplate',
    description = 'Minimal but powerful templating language implemented in multiple languages',
    long_description = __doc__,
    author = 'Jure Vrscaj',
    author_email = 'jure.vrscaj@gmail.com',
    zip_safe = False,
    platforms = 'any',
    packages = [
        'tipfy',
        'tipfy.ext',
        'tipfy.ext.jsontemplate',
    ],
    namespace_packages = [
        'tipfy',
        'tipfy.ext',
    ],
    include_package_data = True,
    install_requires = [
        'tipfy',
        'jsontemplate',
    ],
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ]
)
