# -*- coding: utf-8 -*-
"""
    tipfy.ext.jsontemplate
    ~~~~~~~~~~~~~~~~~~~~~~

    Minimal but powerful templating language implemented in multiple languages

    :copyright: 2010 Jure Vrscaj.
    :license: Apache, see LICENSE.txt for more details.
"""

import os

from tipfy import Tipfy
import jsontemplate

default_config = {
    'templates_dir': 'templates/json',
}


def raw_jsontemplate(filename):
    """ Returns a raw template string.

    :param filename:
        The template filename relative to the templates directory.
    """

    cfg = Tipfy.app.get_config('tipfy.ext.jsontemplate')
    path = os.path.join(cfg["templates_dir"], filename)
    return open(path).read()

def get_template(filename):
    """ Returns a template object.

    :param filename:
        The template filename relative to the templates directory.
    """
    
    return jsontemplate.Template(raw_jsontemplate(filename))
    
def render_template(filename, **context):
    """Renders a JSON template.

    :param filename:
        The template filename, related to the templates directory.
    :param context:
        Keyword arguments used as variables in the rendered template.
    :return:
        A rendered template.
    """
    
    t = get_template(filename)
    return t.expand(context)
